//
//  GHMotionIntensityData.h
//  Garmin Health
//
//  Created by Timar, Mihai on 27/12/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GHActivityType.h"

/**
 *  Data class representing a period of time with a single activityType - movement intensity pair.
 */
@interface GHMotionIntensityData : NSObject <NSCoding>

/** start of the timespan (UTC) */
@property (nonatomic) NSDate* startTime;

/** Duration of this timespan (in s) */
@property (nonatomic) NSNumber *duration;

/** Intensity for this activity in this timespan */
@property (nonatomic) NSNumber *intensity;

/** Activity type for which the intensity was determined. see GHActivityType */
@property (nonatomic) GHActivityType activityType;

/** Convenience. Name for the detected activity type */
@property (nonatomic, readonly) NSString* activityName;


@end
